//librerie utilizzate

#include <LedKey.h>
#include <Wire.h>
#include <LiquidCrystal_I2C.h>

//dichiarazione schermo

LiquidCrystal_I2C lcd(0x3F, 16, 2);  // 0x3F è l’indirizzo assegnato al display

//dichiarazione del modulo ledkey, ovvero il timer

ledkey modulo(7,8,9); // dichiara un oggetto ledkey i cui pin STB, DIO e CLK sono collegati ai pin 7, 8 e 9 di Arduino
timer timer1(10); //dichiara un timer con un ciclo di 1 centesimo

//dichiarazione variabili utili alla lettura del passaggio dell'oggetto

const int pinIRd = 12;
const int pinIRa = A0;
const int pinLED = 13;
int IRvalueA = 0; 
int IRvalueD = 0;

//dichiarazione variabili utili al timer e all'aggiornamento del punteggio

int minuti;
int secondi;
int centesimi;
int punteggio=0;
bool stato; // stato del cronometro: stato=false: fermo; stato=true: attivo

//funzione per visualizzare minuti, secondi e centesimi sul modulo

void visualizza(){
  modulo.displayInt(minuti,1,2);  // visualizza i minuti a partire alla posizione 1 con 2 cifre
  modulo.showCharacter(2,3);  // visualizza il - alla posizione 3
  modulo.displayInt(secondi,4,2);  // visualizza i secondi a partire alla posizione 4 con 2 cifre  
  modulo.showCharacter(2,6);
  modulo.displayInt(centesimi,7,2);
}

void setup() {
  modulo.reset(); //reset del modulo led&Key

  //inizializzazione del timer
  
  minuti=0;
  secondi=0;
  centesimi=0;
  stato=false; 

  //inizializzazione del sensore di movimento
  
  Serial.begin(9600);
  pinMode(pinIRd,INPUT);
  pinMode(pinIRa,INPUT);
  pinMode(pinLED,OUTPUT);

  //inizializzazione dello schermo lcd
  
  lcd.init();
  lcd.backlight();

  //visualizzazione timer
  
  visualizza();
}

void loop() {
  
  //inizio della lettura del passaggio
   
    Serial.print("Analog Reading=");
    Serial.print(IRvalueA);
    Serial.print("\t Digital Reading=");
    Serial.println(IRvalueD);
    delay(30);

  //pulsanti di correzione di eventuali errori di lettura
  
     if (modulo.buttonPressed(8)){
      punteggio++;
      }
      if (modulo.buttonPressed(7)){
      punteggio--;
      }
  
  // controllo del pulsante 2 di reset
  
  if (modulo.buttonPressed(2)){
    minuti=0;
    secondi=0;
    centesimi=0;
    punteggio=0;
    lcd.clear();
    stato=false;
    visualizza();
  }

  // controllo del pulsante 1 start/stop
  
  if (modulo.buttonPressed(1)){
    stato=!stato; //inverte lo stato del cronometro
  }
  
  //inizio timer e visualizzazione delle scritte su schermo
  
    if (stato==true){
      timer1.start(); // fa partire il cronometro
      lcd.clear();
      lcd.print("Punteggio:");
      lcd.setCursor(0,1);
      lcd.print(punteggio);
      
      //aggiornamento del punteggio una volta letto il passaggio dell'oggetto
      
      if (IRvalueD == LOW) {
    digitalWrite(LED_BUILTIN, HIGH);
    punteggio++;
    lcd.setCursor(0,1);
    lcd.clear();
      lcd.print(punteggio);
  }
  else {

    //nessun agggiornamento in caso di mancata lettura del passaggio
    
 digitalWrite(LED_BUILTIN, LOW);
}
    }
  
  // incrementa il tempo in base a timerC se stato=true
  
  if (stato==true){
    if (timer1.isTimeout()){
      centesimi++;
      // controlla se passato un minuto
      if(centesimi==100){
        centesimi=0;
        secondi++;
      if (secondi==60){
        secondi=0;
        minuti++;      
        if (minuti==1){ // limite massimo 1 minuto
          minuti=0;
          secondi=0;
          centesimi=0;
          lcd.clear();
          
          //fine gioco e visualizzazione del punteggio finale
          
          lcd.print("STOP! P.finale:");
          lcd.setCursor(0,1);
          lcd.print(punteggio);
          delay(2000);
          stato=!stato;
        }
      }
      }

      timer1.start(); // azzera il timerC e ricomincia il conteggio
      visualizza(); // visualizza minuti e secondi
      
    }    
  }

  //variabili della lettura del passaggio aggiornate
  
  IRvalueA = analogRead(pinIRa);
  IRvalueD = digitalRead(pinIRd);
}
