#include "LedKey.h"
#include <Arduino.h>

//module class

//constructor
ledkey::ledkey(int strobePin, int dataPin, int clockPin){
	strobe=strobePin;
	data=dataPin;
	clock=clockPin;
	pinMode(strobe, OUTPUT);
	pinMode(data, OUTPUT);
	pinMode(clock, OUTPUT);
	sendCommand(0x8a);  // activate and set brightness to max
	reset(); // reset module
}

//methods
void ledkey::sendCommand(uint8_t value)
{
  //sends a command to TM1638
  digitalWrite(strobe, LOW);
  shiftOut(data, clock, LSBFIRST, value);
  digitalWrite(strobe, HIGH);
}

void ledkey::showDigit(uint8_t number, uint8_t position, bool dp)
{
  //shows a number at position 
  if (position<=8 && position>0)
  {
  	digitalWrite(strobe, LOW);
  	shiftOut(data, clock, LSBFIRST, 0xc0+(position-1)*2); 
  	shiftOut(data, clock, MSBFIRST, mCifre[number]+dp);
  	digitalWrite(strobe, HIGH);  
	  
	_digitState[position-1]=mCifre[number]+dp;	
  }
}

void ledkey::clearDigit(uint8_t position)
{
  //switches a digit off
  showCharacter(0,position);		
}

void ledkey::showCharacter(uint8_t value, uint8_t position)
{
  //shows a character at position
  //value represnts the 8 digit code
  if (position<=8 && position>0)
  {
  	digitalWrite(strobe, LOW);
  	shiftOut(data, clock, LSBFIRST, 0xc0+(position-1)*2); 
  	shiftOut(data, clock, MSBFIRST, value);
  	digitalWrite(strobe, HIGH);
  	
  	_digitState[position-1]=value;
  }
}

void ledkey::setLed(uint8_t position, uint8_t value)
{
  // switches on/off a led
  sendCommand(0x44);
  if (position<=8 && position>0)
  {
  	digitalWrite(strobe, LOW);
	shiftOut(data, clock, LSBFIRST, 0xc1+(position-1)*2); 
  	shiftOut(data, clock, LSBFIRST, value);
  	digitalWrite(strobe, HIGH);
  	
  	_ledState[position-1]=value;
  }    
}

void ledkey::toggleLed(uint8_t position)
{
  // toggles a led
  if (position<=8 && position>0)
  {
  	_ledState[position-1]=!_ledState[position-1];
  	setLed(position,_ledState[position-1]);
  }		
}

void ledkey::ledBar(uint8_t n)
{
  //switches leds 
  for(int i=1;i<=8;i++)
  {
    if (i<=n)
    {
      setLed(i,HIGH); 
    }
    else
    {
      setLed(i,LOW);
    }
  }
}

void ledkey::showMsg(messId mId)
{
  //shows a message
  sendCommand(0x44);
  switch (mId)
  {
    case ERR:
      for(int i=1;i<=8;i++)
      {
        showCharacter(error[i-1],i);  
      }
      break;
  }
}

void ledkey::displayFloat(double n, int decimalPlaces)
{
  // shows float/double number on 8 digits
  //   
  sendCommand(0x44);
  String s=String(n,decimalPlaces);
  int l=s.length();
  int p=9-l;
  int l1=l;
  if (s.indexOf('.')!=-1)
  {
    p++;
    l1--;
  }
  int a=0;
  for(int i=1;i<p;i++)
  {
  	clearDigit(i);
  }
  if (l1<=8)
  {
    if (n<0)
    {
      showCharacter(2,p);
      a=1;
      p=p+1;
    }
    for(int i=a;i<l;i++)
    {
      if (s.charAt(i+1)=='.')
      {
        showDigit(s.substring(i,i+1).toInt(),p,true);
        i++;
      }
      else
      {
        showDigit(s.substring(i,i+1).toInt(),p);      
      }
      p=p+1;  
    }
  }
  else
  {
    showMsg(ERR);
  }
}

void ledkey::displayInt(long n, int startPosition=0, int digits=0)
{
  sendCommand(0x44);
  String s=String(n);
  int l=s.length();
  int m=digits-l;
  for (int i=1;i<=m;i++){
    s='0'+s;
    l++;
  }
  int p;
  if(startPosition!=0){
    p=startPosition;
  } else {
    p=9-l;
  }
  
  int a=0;
  if (l<=8)
  {
    if (n<0)
    {
      showCharacter(2,p);
      a=1;
      p=p+1;
    }
    for(int i=a;i<l;i++)
    {
      showDigit(s.substring(i,i+1).toInt(),p);
      p=p+1;
    }
  }
  else
  {
    showMsg(ERR);
  }
}

void ledkey::reset()
{
  //resets module
  sendCommand(0x40); // set auto increment mode
  digitalWrite(strobe, LOW);
  shiftOut(data, clock, LSBFIRST, 0xc0);   // set starting address to 0
  for(uint8_t i = 0; i < 16; i++)
  {
    shiftOut(data, clock, LSBFIRST, 0x00);
  }
  digitalWrite(strobe, HIGH);
  for(uint8_t i=0;i<8;i++)
  {
  	_ledState[i-1]=false;
  	_digitState[i-1]=0;
  }
}

bool ledkey::ledState(uint8_t n)
{
  // returns the nth led state
  if (n<=8 && n>0)		
  {
  	return _ledState[n-1];
  }
  else
  {
  	return false;
  }
}

uint8_t ledkey::digitState(uint8_t n)
{
  // returns the nth led state
  if (n<=8 && n>0)		
  {
  	return _digitState[n-1];
  }
  else
  {
  	return 0;
  }
}

bool ledkey::buttonPressed(uint8_t pButton)
{
  // checks if pButton is pressed
  if (pButton<=8 && pButton>0)
  {
	  pButton--;
	  
	  bool pressed=false;
	  uint8_t b=readButtons();
	  uint8_t m=1;
	  m=m<<(pButton);
	  int readState;
	  if (b & m )
	  {
	    readState=true;
	  }
	  else
	  {
	    readState=false;
	  }
	  
	  if (readState != lastState[pButton])
	  {
	    startTimer[pButton]=millis();
	  }
	  
	  if (millis()-startTimer[pButton]>debounceDelay)
	  {
	    if(readState != currentState[pButton])
	    {
	      currentState[pButton]=readState;
	      pressed=readState;
	    }
	  }
	  lastState[pButton]=readState;
	  return pressed;  	
  }
  else
  {
  	return false;
  }

}

uint8_t ledkey::readButtons()
{
  //checks pressed buttons
  
  uint8_t buttons = 0;
  digitalWrite(strobe, LOW);
  shiftOut(data, clock, LSBFIRST, 0x42);
 
  pinMode(data, INPUT);
 
  for (uint8_t i = 0; i < 4; i++)
  {
    uint8_t v = shiftIn(data, clock, LSBFIRST) << i;
    buttons |= v;
  }
 
  pinMode(data, OUTPUT);
  digitalWrite(strobe, HIGH);
  return buttons;  
}

//led class

//constructor
led::led(int pinLed){
pin=pinLed;
pinMode(pin, OUTPUT);
digitalWrite(pin, LOW);
}

//methods
void led::on(){
	digitalWrite(pin, HIGH);
}
void led::off(){
	digitalWrite(pin, LOW);
}
void led::toggle(){
	digitalWrite(pin, !digitalRead(pin));
}
int led::state(){
	digitalRead(pin);
}


//timer class

//constructor
timer::timer(long interval){
set(interval);
}

//methods
void timer::start(){
	startTime=millis();
}
void timer::set(long interval){
	timeoutValue=interval;
}
bool timer::isTimeout(){
	if (millis()-startTime>=timeoutValue)
	{
	  return true;
	}
	else
	{
	  return false;
	}
}


//button class

//constructor
button::button(int buttonPin){
	pin=buttonPin;
	pinMode(pin, INPUT);
	lastState=LOW;
	currentState=LOW;
	startTimer=0;
}

//methods
bool button::isPressed(){
	bool pressed=false;
	int readState=digitalRead(pin);
	
	if (readState != lastState)
	{
	  startTimer=millis();
	}
	
	if (millis()-startTimer>debounceDelay)
	{
	  if(readState != currentState)
	  {
	    currentState=readState;
	    if (readState==HIGH)
	    {
	      pressed=true;
	    }
	  }
	}
	lastState=readState;
	return pressed;
}

