#ifndef LedKey_h
#define LedKey_h

#include <Arduino.h>

//class definitions
enum messId {ERR};

//module led&key class
class ledkey{
  
  // display data  		
  int mCifre[10]={252,96,218,242,102,182,190,224,254,246}; // codes for numbers on 7 segment digit
  int error[8]={158,10,10,58,10,158,0,0}; // ERR message
  
  // button debounce variables
  const long debounceDelay=5;
  bool lastState[8];
  long startTimer[8];
  bool currentState[8];
  
  // led state
  bool _ledState[8];
  // display state
  uint8_t _digitState[8];
  
  public:
  int strobe; // strobe pin
  int data; // data pin
  int clock; // clock pin
  ledkey(int strobePin, int dataPin, int clockPin); // constructor
  bool ledState(uint8_t n); // return the nth led state
  uint8_t digitState(uint8_t n);  // returns the nth digit state
  void sendCommand(uint8_t value); // send a command to module
  void showDigit(uint8_t number, uint8_t position, bool dp=false); // shows a digit at the position w/o dot
  void clearDigit(uint8_t position);  // switches the position digit off 
  void showCharacter(uint8_t value, uint8_t position); // shows a character at position from 8 digit code value
  void setLed(uint8_t position, uint8_t value); // switches position led on/off - HIGH/LOW
  void toggleLed(uint8_t position); // toggles the state of position led
  void ledBar(uint8_t n); // switches n leds from led1 - n = 1..8
  void showMsg(messId mId); // shows a preformatted message - available: ERR
  void displayFloat(double n, int decimalPlaces=2); // displays a double/float number with decimalPlaces
  void displayInt(long n, int startPosition=0, int digits=0); // displays a long/int number
  void reset(); // module reset
  bool buttonPressed(uint8_t pButton); // checks if pButton is pressed
  uint8_t readButtons(); // returns in a byte which buttons are pressed
  
};

//led class
class led{
  public:
  int pin; //pin
  led(int pinLed); //constructor
  void on(); //switches the led on
  void off(); //switches the led off
  void toggle(); //toggles the led
  int state(); //returns the state of led
};

//timer class
class timer{
  long timeoutValue;
  long startTime;
  public:  
  timer(long interval); //constructor
  void start(); //starts timer
  void set(long interval); //sets the interval
  bool isTimeout(); //timeout check
};

//button class
class button{
  const long debounceDelay=10;
  int lastState;
  int currentState;
  long startTimer;
  public:
  int pin;
  button(int buttonPin); //constructor
  bool isPressed(); //checks if the button is pressed
};

#endif
