
#include <LiquidCrystal_I2C.h>
#include <Wire.h>
#include <Servo.h>
#include <Adafruit_Fingerprint.h>
#include <IRremote.h>
#include <IRremoteInt.h>
  
Servo myservo;
LiquidCrystal_I2C lcd(0x3F,16,2);
SoftwareSerial mySerial(2, 3);
Adafruit_Fingerprint finger = Adafruit_Fingerprint(&mySerial);

int receiver = 11; // pin 1 of IR receiver to Arduino digital pin 11
IRrecv irrecv(receiver); // create instance of 'irrecv'
decode_results results;
String stringa = "";
int stato=0; // 0 impronte 1 telecomando
void setup()  
{pinMode(13, OUTPUT);
pinMode(12,OUTPUT);
  digitalWrite(12, HIGH);
   myservo.attach(9);
    lcd.init(); 
    lcd.backlight();
  Serial.begin(9600);
  while (!Serial);  // For Yun/Leo/Micro/Zero/...
  delay(100);
  Serial.println("\n\nAdafruit finger detect test");

  // set the data rate for the sensor serial port
  finger.begin(57600);
  
  if (finger.verifyPassword()) {
    Serial.println("Found fingerprint sensor!");
  } else {
    Serial.println("Did not find fingerprint sensor :(");
    while (1) { delay(1); }
  }

  finger.getTemplateCount();
  Serial.print("Sensor contains "); Serial.print(finger.templateCount); Serial.println(" templates");
  Serial.println("Waiting for valid finger...");
  irrecv.enableIRIn(); // Start the receiver
}

void loop()      {   // run over and over again

  if (stato==0){
    getFingerprintIDez();
  }else {
    checkPassword();
  }
  
  
  delay(50);            //don't ned to run this at full speed.
}


uint8_t getFingerprintID() {
  uint8_t p = finger.getImage();
  switch (p) {
    case FINGERPRINT_OK:
      Serial.println("Image taken");
      break;
    case FINGERPRINT_NOFINGER:
      Serial.println("No finger detected");
      return p;
    case FINGERPRINT_PACKETRECIEVEERR:
      Serial.println("Communication error");
      return p;
    case FINGERPRINT_IMAGEFAIL:
      Serial.println("Imaging error");
      return p;
    default:
      Serial.println("Unknown error");
      return p;
  }

  // OK success!

  p = finger.image2Tz();
  switch (p) {
    case FINGERPRINT_OK:
      Serial.println("Image converted");
      break;
    case FINGERPRINT_IMAGEMESS:
      Serial.println("Image too messy");
      return p;
    case FINGERPRINT_PACKETRECIEVEERR:
      Serial.println("Communication error");
      return p;
    case FINGERPRINT_FEATUREFAIL:
      Serial.println("Could not find fingerprint features");
      return p;
    case FINGERPRINT_INVALIDIMAGE:
      Serial.println("Could not find fingerprint features");
      return p;
    default:
      Serial.println("Unknown error");
      return p;
  }
  
  // OK converted!
  p = finger.fingerFastSearch();
  if (p == FINGERPRINT_OK) {
    Serial.println("Found a print match!");
  } else if (p == FINGERPRINT_PACKETRECIEVEERR) {
    Serial.println("Communication error");
    return p;
  } else if (p == FINGERPRINT_NOTFOUND) {
    Serial.println("Did not find a match");
    return p;
  } else {
    Serial.println("Unknown error");
    return p;
  }   
  
  // found a match!
  Serial.print("Found ID #"); Serial.print(finger.fingerID); 
  Serial.print(" with confidence of "); Serial.println(finger.confidence); 

  return finger.fingerID;
}

// returns -1 if failed, otherwise returns ID #
int getFingerprintIDez() {
  uint8_t p = finger.getImage();
  if (p != FINGERPRINT_OK)  return -1;

  p = finger.image2Tz();
  if (p != FINGERPRINT_OK)  return -1 ;
  
  p = finger.fingerFastSearch();
  if (p != FINGERPRINT_OK)
  {
    lcd.setCursor(0,0);
    lcd.print("INSERT PASSWORD");
    stato=1;
    return -1;
  }
  
  
  // found a match!
  digitalWrite(13, HIGH);
   digitalWrite(12, LOW);

   if (finger.fingerID== 3)
{  lcd.print("WELCOME");
  lcd.setCursor(0,1);
  lcd.print("SIMONE");
  delay(1000);
  lcd.clear();}
   else if (finger.fingerID== 4)
 { lcd.print("WELCOME");
   lcd.setCursor(0,1);
  lcd.print("FRANCESCO");
 delay(1000);
 lcd.clear();}
    else if(finger.fingerID== 2)
 { lcd.print("WELCOME");
   lcd.setCursor(0,1);
  lcd.print("ANTONIO");
 delay(1000);
 lcd.clear();}
  myservo.write(180);
 digitalWrite(13, LOW);
 delay(2000);
 digitalWrite(12, HIGH);

 stato=1;


  
  Serial.print("Found ID #"); Serial.print(finger.fingerID); 
  Serial.print(" with confidence of "); Serial.println(finger.confidence);
  return finger.fingerID; 
}

void checkPassword(){
  if (irrecv.decode(&results)) // have we received an IR signal?
{

Serial.println(results.value, HEX); // display it on serial monitor in hexadecimal
irrecv.resume();// receive the next value
if (results.value == 0xFFA25D)
{
  myservo.write(60);
  stato=0;
  exit;
}
if ( results.value == 0xFF4AB5)
{
stringa = stringa +"8"; 
} // memorizzo primo valore password (8)
if(results.value== 0xFF38C7)
{ 
stringa  = stringa +"5";}// memorizzo secondo valore password (5)
if(results.value== 0xFF18E7)
{
stringa  = stringa +"2";}//memorizzo terzo valore password (2)
Serial.println(stringa);
if ( stringa.length()== 3 )
// controllo password
{ if (stringa == "852") 
{
digitalWrite(12,LOW);
digitalWrite(13,HIGH);
lcd.clear();
lcd.setCursor(0,0);
lcd.print("CORRECT PASSWORD"); // spegni luce rossa, accendi luce verde e scrivi 
lcd.setCursor(0,1);
lcd.print(" ");
myservo.write(180);
delay(2000);
lcd.clear();
stringa = "";
digitalWrite(13,LOW);
delay(1000);
digitalWrite(12,HIGH);
stato=1;

}else {
lcd.print("WRONG PASSWORD");
delay(2000);
lcd.clear();
stringa="";
stato=0;

}
}
}
}

